/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __TASK_HEADERS__H__
#define __TASK_HEADERS__H__

#include <pan/base/group.h>

#include <pan/task.h>

/**
***  TASK_HEADERS CLASS DECLARATION
**/

#define TASK_HEADERS(a) ((TaskHeaders *)a)

typedef struct _TaskHeaders TaskHeaders;

typedef enum
{
	HEADERS_ALL,
	HEADERS_NEW,
	HEADERS_SAMPLE
}
HeaderDownloadType;

struct _TaskHeaders
{
	/*Parent Class*/
	Task item;

	/* Fields */
	Group * group;
	GPtrArray * headers_needing_bodies;
	HeaderDownloadType download_type;
	gboolean download_bodies;
	int body_index;
	int sample_size;
};


/**
***  PUBLIC
**/

PanObject* task_headers_new_sample        (Group               * group,
                                           guint                 sample_size,
                                           gboolean              dl_bodies);

PanObject* task_headers_new               (Group               * group,
                                           HeaderDownloadType    type);

PanObject* task_headers_new_with_bodies   (Group               * group,
					   HeaderDownloadType    type);

#endif
