///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "aboutdialog.h"
#include "safeslot.h"
#include "globals.h"
#include <gtk--/label.h>
#include <gtk--/button.h>

About_Dialog::About_Dialog():
  Gtk::Dialog()
{
  //  set_modal(true);
  set_title("About Passepartout");
  set_policy(false, false, true);
  Gtk::Label *message=
    manage(new Gtk::Label(
			  "Passepartout "+version+"\n"
			  "Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj"
			  ));
  message->set_justify(GTK_JUSTIFY_LEFT);
  Gtk::Button *ok_button=manage(new Gtk::Button(" Hide "));
  ok_button->set_flags(GTK_CAN_DEFAULT);
  get_action_area()->pack_start(*ok_button, true, false, 0);
  get_action_area()->show_all();
  get_vbox()->set_border_width(border_width);
  get_vbox()->set_spacing(border_width);
  get_vbox()->pack_start(*message, true, true, 0);
  get_vbox()->show_all();
  ok_button->grab_default();
  ok_button->clicked.connect(safeslot(this, &About_Dialog::ok));
}

