///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "basicframe.h"
#include <util/stringutil.h>
#include <util/warning.h>
#include <sigc++/signal_system.h>
#include <gdk--.h>
#include <fstream>
#include <algorithm>
#include <xml++.h>

void Basic_Frame::draw_content_error(View& view, const Gdk_Pixmap &pixmap) 
{
  if(pixmap) {
    // p is the top left corner, since that is what draw_pixmap wants.
    const Gdk_Point p = view.pt2scr(get_matrix().transform(Vector(0, height)));
    view.get_win().draw_pixmap(view.get_gc(), pixmap, 0, 0, p->x, p->y);
  } 
}

void Basic_Frame::draw_content_wait(View& view) 
{
  draw_content_error(view, view.get_wait_pixmap());
}

void Basic_Frame::draw_content_missing(View& view) 
{
  draw_content_error(view, view.get_missing_pixmap());
}

void Basic_Frame::draw_content_broken(View& view) 
{
  draw_content_error(view, view.get_broken_pixmap());
}

void Basic_Frame::move_reshape_box(int box, Vector v)
{
  Matrix m=get_matrix();
  Matrix sh_m=Matrix::shearing(m.sh());
  Matrix sc_m=Matrix::scaling(m.sc_x(), m.sc_y());
  Matrix rot_m=Matrix::rotation(m.rot());
  Matrix tr_m=Matrix::translation(m.tr_x(), m.tr_y());
  double sc_x=m.sc_x();
  double sc_y=m.sc_y();
  double xsize=fabs(width*sc_x);
  double ysize=fabs(height*sc_y);
  //  double w=width;
  //  double h=height;
  double w=xsize;
  double h=ysize;
  double xpos=0;
  double ypos=0;

  // transform vector to frame coordinates
  //  v=(sh_m*Matrix::scaling(sc_x, sc_y)*rot_m).transform(v);

  //Compensating for mirroring. This is not pretty: 
  /*
  if(sc_x<0)
    {
      switch(box)
	{
	case 1: box=3; break;
	case 3: box=1; break;
	case 4: box=5; break;
	case 5: box=4; break;
	case 6: box=8; break;
	case 8: box=6; break;
	default: break;
	}
    }
  if(sc_y<0)
    {
      switch(box)
	{
	case 1: box=6; break;
	case 2: box=7; break;
	case 3: box=8; break;
	case 6: box=1; break;
	case 7: box=2; break;
	case 8: box=3; break;
	default: break;
	}
    }
  */
  switch(box)
    {
    case 6:
      xpos+=v.x;
      ypos-=v.y;
      w-=v.x;
      h+=v.y;
      break;
    case 7:
      ypos-=v.y;
      h+=v.y;
      break;
    case 8:
      ypos-=v.y;
      w+=v.x;
      h+=v.y;
      break;
    case 4:
      xpos+=v.x;
      w-=v.x;
      break;
    case 5:
      w+=v.x;
      break;
    case 1:
      xpos+=v.x;
      w-=v.x;
      h-=v.y;
      break;
    case 2:
      h-=v.y;
      break;
    case 3:
      w+=v.x;
      h-=v.y;
      break;
    default:
      warning << "StupidProgrammerError:"
	      << "motion_notify_event_impl reached default!" 
	      << std::endl;
      break;
    }
  
  //  m.set_scale(sc_x*w/width, sc_y*h/height);
  //  set_matrix(m);//*Matrix::translation(xpos, ypos));
  Matrix scaling=Matrix::scaling(w/xsize, h/ysize)*sc_m;
  const double min_scale=0.00001;
  //this is a bad solution:
  if(scaling.sc_x()>min_scale && scaling.sc_y()>min_scale)
    set_matrix(
	       sh_m
	       *scaling
	       *rot_m
	       *tr_m*Matrix::translation(xpos, ypos));
}

Basic_Frame::Basic_Frame(Group *parent, FLength w, FLength h, 
			 const std::string& name)
  :Pagent(parent, name), width(w), height(h)
{}

Basic_Frame::Basic_Frame(Group *parent, const XMLNode& node)
  :Pagent(parent, "unnamed")
{
  if(const XMLProperty* name = node.property("name"))
    set_name(name->value());

  if(const XMLProperty* locked = node.property("lock"))
    lock(locked->value()=="true");

  if(const XMLProperty* flow = node.property("flowaround"))
    flow_around=(flow->value()=="true");
  
  if(const XMLProperty* matrix = node.property("matrix")) {
    set_matrix(to<Matrix>(matrix->value()));
  } else
    throw Error::Read("No \"matrix\" tag found in frame.");
}

XMLNode *Basic_Frame::save()
{
  XMLNode *node=new XMLNode("frame");
  if(name!="")
    node->add_property("name", name);

  node->add_property("matrix", tostr(get_matrix()));
  node->add_property("lock", is_locked()?"true":"false");
  node->add_property("flowaround", flow_around?"true":"false");

  return node;
}

Basic_Frame::~Basic_Frame()
{
}

void Basic_Frame::print(std::ostream &out)
{
}

Box Basic_Frame::get_box() const 
{
  return Box(width, height) *= get_matrix();
}

void Basic_Frame::set_size(FLength w, FLength h) 
{
  if(width == w && height == h)
    return;
  
  width=w;
  height=h;
  geometry_changed_signal(this);
  ready_to_draw_signal(this);
}

Boundary* Basic_Frame::getObstacleBoundary() const {
  // Todo:  Decide how to handle this memory ...
  if(flow_around)
    return new RectBoundary(get_matrix(), width, height);
  else
    return 0;
};
