///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef BASICFRAME_H
#define BASICFRAME_H

#include "units.h"
#include "pagent.h"
#include "fileerrors.h"
#include <iostream>

namespace Error
{
  struct Frame_Type: public File {
    Frame_Type(const string& msg) : File("Frame-type error: " + msg) {}
  };
}

class Basic_Frame: public Pagent
{
protected:
  FLength width, height;

public:
  Basic_Frame(Group *parent, FLength w, FLength h, const std::string& name);
  Basic_Frame(Group *parent, const XMLNode& node);
  virtual ~Basic_Frame();
  
  virtual XMLNode *save();
  virtual void print(std::ostream &out);

  Box get_box() const;

  virtual void move_reshape_box(int box, Vector v);

  //  virtual void act_on_zoom_factor_change() {};

  void set_size(FLength w, FLength h);
  virtual FLength get_width() const {return width;}
  virtual FLength get_height() const {return height;}
  
  Boundary* getObstacleBoundary() const;

  // Errors reported by generate_picture:
  // ASSOCIATION - failed to open associated file
  //  GENERATION - general error (missing program, corrupted file, et cetera)
  //    ZEROSIZE - picture has zero size
  enum Gen_Pic_Error_Type { ASSOCIATION, GENERATION, ZEROSIZE }; 
  struct Gen_Pic_Error : public std::logic_error {
    Gen_Pic_Error_Type type;
    Gen_Pic_Error(Gen_Pic_Error_Type t, std::string s)
      : logic_error(s), type(t) {}
    ~Gen_Pic_Error() throw() {}
  };
  
  void draw_content_error(View& view, const Gdk_Pixmap &pixmap);
  void draw_content_wait(View& view);
  void draw_content_missing(View& view);
  void draw_content_broken(View& view);
};

#endif
