///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "boundary.h"
#include <iostream>

RectBoundary::RectBoundary(const Matrix& m,
			   const double width, const double height)
  :matrix(m)
{
  matrix.set_scale(matrix.sc_x() * width, matrix.sc_y() * height);
  // Beware: set_scale will throw Error::Singular_Matrix
  // if any of the parameters is 0
}

std::ostream& RectBoundary::print(std::ostream& out) const {
  Vector origo = matrix.transform(Vector(0, 0));
  Vector size = matrix.transform(Vector(1, 1)) - origo;
  
  out << size.x << "x" << size.y
      << (origo.x>=0? "+": "") << origo.x
      << (origo.y>=0? "+": "") << origo.y;
  
  return out;
}

std::ostream& RectBoundary::print(std::ostream& out, const Matrix& m) const {
  Vector origo = m.transform(matrix.transform(Vector(0, 0)));
  Vector size = m.transform(matrix.transform(Vector(1, 1))) - origo;
  
  out << size.x << "x" << size.y
      << (origo.x>=0? "+": "") << origo.x
      << (origo.y>=0? "+": "") << origo.y;
  
  return out;
}

bool RectBoundary::operator == (const Boundary& other) const {
  const RectBoundary* other_r = dynamic_cast<const RectBoundary*>(&other);
  return other_r && matrix == other_r->matrix;
}

