///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef CACHEDFRAME_H
#define CACHEDFRAME_H

#include "basicframe.h"
#include <gdk--.h>
#include <sys/types.h>

class Cached_Frame: public Basic_Frame {
public:
  Cached_Frame(Group *parent, FLength w, FLength h,
	       const std::string& name);
  Cached_Frame(Group *parent, const XMLNode& node);
  virtual ~Cached_Frame();

  virtual void end_reshape(bool revert);

  void clear_picture();
  void clear_cache() { clear_picture(); }

  virtual void act_on_zoom_factor_change();

protected:
  
  bool no_picture_generated; 
  // true if no cached file has been generated when process_stopped is called

  bool white_is_transparent; // fake transparency

  virtual void generate_picture(View& view) = 0;
  bool draw_content(View& view);
  void process_stopped(pid_t  pid, bool exited_normally, int exit_code);
  
  Gdk_Pixmap picture;
  Gdk_Bitmap mask;
  std::string tmp_file;
  pid_t pid;
  SigC::Connection proc_stop_connection;
};

#endif



