///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef DOCPROPSDIALOG_H
#define DOCPROPSDIALOG_H

#include <gtk--/dialog.h>
#include <gtk--/radiobutton.h>
#include <gtk--/checkbutton.h>
#include <gtk--/frame.h>
#include <gtk--/combo.h>
#include "widget/filesel.h"
#include "widget/spinner.h"

class Document_View;

class Doc_Props_Dialog : public Gtk::Dialog
{
public:
  Gtk::CheckButton template_button;
  Gtk::RadioButton portrait_button, landscape_button,
    single_sided_button, double_sided_button;
  Gtk::Frame frame;
  Gtk::Combo paper_size;
  File_Entry file_entry;
  Filesel *filesel;
  Document_View &view;
  Spinner first_page;
  bool new_document;

  void cancel();
  void ok();
  void update_mode();
public:
  Doc_Props_Dialog(Gtk::Window &parent, Document_View &view_);
  void show_it(bool new_document_);
  int delete_event_impl(GdkEventAny*)
  {hide(); return true;}
};

#endif
