///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "errordialog.h"
#include "globals.h"
#include <util/warning.h>
#include <string>

Error_Dialog* Error_Dialog::dialog = 0;

void Error_Dialog::init(Gtk::Window& parent) {
  if(!dialog)
    dialog = new Error_Dialog(parent);
}

void Error_Dialog::view(const std::string& message) {
  if(dialog)
    dialog->show_message(message);
  else {
    const std::string line(" - - - - - - - - - - - - - - - - - - - - - - - ");
    warning << "\n" << line
	    << "\n\t" << "Error:" << "\n\t" << message
	    << "\n" << line << "\n";
  }
}

Error_Dialog::Error_Dialog(Gtk::Window &parent)
  :ok_button(" OK ")
{
  set_transient_for(parent);
  set_border_width(border_width);
  set_modal(true);
  set_title("Error");
  set_policy(false, false, true);
  get_action_area()->pack_start(ok_button, true, false, 0);
  get_vbox()->pack_start(message_, true, true, 0);
  // Don't use safeslot here, since it uses Error_Dialog!  Instead, make the
  // ok function simple so it doesn't emit any exception.
  ok_button.clicked.connect(slot(this, &Error_Dialog::ok));
}

void Error_Dialog::show_message(const std::string& message) {
  message_.set_text(message);
  show_all();
}

int Error_Dialog::delete_event_impl(GdkEventAny*) {
  ok(); 
  return true;
}
