///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef ERRORDIALOG_H
#define ERRORDIALOG_H

#include <gtk--/dialog.h>
#include <gtk--/label.h>
#include <gtk--/button.h>
#include <string>

class Error_Dialog : public Gtk::Dialog {
public:
  static void init(Gtk::Window& parent);
  static void view(const std::string& message);

  Error_Dialog(Gtk::Window &parent);
  
  void show_message(const std::string& message);
  int delete_event_impl(GdkEventAny*);

private:
  static Error_Dialog* dialog;
  
  Gtk::Button ok_button;
  Gtk::Label message_;
  void ok() { hide(); }
};

#endif
