///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "filewatcher.h"
#include "safeslot.h"
#include <sys/stat.h>

std::string File_Watcher::file_type() const
{
  const std::string tmp=file_to_watch();
  if(tmp.length()>4)
    return tmp.substr(tmp.length()-3, 3);
  else
    return "";
}

File_Watcher::File_Watcher()
{
  connection=Gtk::Main::timeout
    .connect(safeslot(this, &File_Watcher::check_file), 100);
}

File_Watcher::~File_Watcher()
{
  connection.disconnect();
}

gint File_Watcher::check_file()
{
  const std::string filename = file_to_watch();
  struct stat buf;
  if(filename=="")
    return true;
  if(stat(filename.c_str(), &buf)==0)
    if(buf.st_mtime!=last_time)   // maybe st_ctime instead?
      {
	last_time=buf.st_mtime;
	file_modified();
      }
  return true;
}










