///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef GROUP_H			// -*- c++ -*-
#define GROUP_H
#include "pagent.h"
#include <list>

enum Rearrange_Action { UP, DOWN, TOP, BOTTOM };

class Group : public Pagent {
public:
  typedef std::list<Pagent*> ChildVec;
  
  Group(Group *parent, const std::string& name);
  Group(Group *parent, const std::string& name, const Matrix& xform);
  virtual ~Group();
  
  XMLNode* save();
  
  void print(std::ostream& out);
  bool draw_content(View& view);
  void clear_cache();

  Box get_box() const;
  void move_reshape_box(int i, Vector v);
  void setFlowAround(bool);
  bool getFlowAround() const;
  Boundary * getObstacleBoundary() const;
  BoundaryVect Group::obstacle_list() const;
  
  void act_on_zoom_factor_change();

  void add(Pagent* obj);
  Pagent* ungroup(Pagent* obj);
  void rearrange_selected(Rearrange_Action action);
  void group_selected();
  void ungroup_selected();
  int count() const {return childs.size();}
//protected:
  void saveChilds(XMLNode& node);
  ChildVec::const_iterator pbegin() const { return childs.begin(); }
  ChildVec::const_iterator pend() const { return childs.end(); }
  ChildVec::const_reverse_iterator prbegin() const { return childs.rbegin(); }
  ChildVec::const_reverse_iterator prend() const { return childs.rend(); }

  // A change in a child is a change in the group:
  virtual void child_ready_to_draw(Pagent *pagent);
  virtual void child_props_changed(Pagent *pagent);
  virtual void child_geometry_changed(Pagent *pagent);
private:
  ChildVec childs;
};

#endif
