///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "groupmeta.h"
#include "group.h"
#include "pptcore.h"
#include "fileerrors.h"
#include <xml++.h>
#include <util/warning.h>
#include <util/stringutil.h>

Pagent*
GroupMeta::load(const XMLNode& node, Group* parent) {
  Matrix m;
  std::string name = "group";
  if(const XMLProperty* xform = node.property("transform"))
    m = to<Matrix>(xform->value());
  if(const XMLProperty* namep = node.property("name"))
    name = namep->value();
  Group* g = new Group(parent, name, m);
  
  // read pagents:  Todo: Avoid duplicate (page.cc:43)
  const XMLNodeList children = node.children();
  for(XMLNodeList::const_iterator i=children.begin();
      i!=children.end();
      i++)
    {
      std::string name=(*i)->name();
      if(name=="frame")
	{
	  const XMLProperty* type_node = (*i)->property("type");
	  if(!type_node)
	    throw Error::Read("No type attribute for frame");
	  
	  const std::string type = type_node->value();
	  
	  if(MetaBase* loader = core.getMeta(type))
	    g->add(loader->load(*i, g));
	  
	  else
	    throw Error::Read("No appropriate loader for  \"" + type + "\".");
	}
      else
	warning << "Unknown tag \"" << name
		<< "\" ignored in group." << std::endl;
    }
  return g;
}

PropBase* GroupMeta::getProp() { return 0; }
