///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef IMAGEFRAME_H
#define IMAGEFRAME_H

#include "filewatcher.h"
#include "cachedframe.h"

class Image_Frame: public Cached_Frame, public File_Watcher
{
public:
  Image_Frame(Group *parent, 
	      const std::string& assoc,
	      FLength w, FLength h);
  Image_Frame(Group *parent, const XMLNode& node);
  virtual ~Image_Frame();

  virtual XMLNode *save();
  virtual void print(std::ostream &out);

  void set_association(std::string s);
  std::string get_association() const {return association;}

protected:
  std::string association, parsed_file;
 
  void generate_picture(View& view);
  std::string file_to_watch() const
  {return association;}
  void file_modified();
  void parse(std::istream &in, std::ostream &out);
  void read_size();
};

#endif
