///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "imagemeta.h"
#include "imageframe.h"
#include "propbase.h"
#include "streamdialog.h"
#include <gtk--/label.h>

Pagent* ImageMeta::load(const XMLNode& node, Group* parent){
  return new Image_Frame(parent, node);
}

// Properties for a EPS image, as represented by Image_Frame.
// Currently just displays the filename.  It should be able to change the file
// name and possibly display some of the header info from the EPS (title,
// created by, etc).
class PropImage : public GenericProp<Image_Frame> {
public:
  PropImage()
    :GenericProp<Image_Frame>("EPS", 4, 3),
    l_fname("Filename:"),
    e_fname("Associated File")
    {
      attach(l_fname, 0, 1, 0, 1, 0, 0);
      attach(e_fname, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, 0);
      set_sensitive(false);
      update();
    }
  
  void update() {
    if(object) {
      e_fname.entry.set_text(object->get_association());
    } else {
      e_fname.entry.set_text("");
    }
  }
  void apply() {
    if(object)
      object->set_association(e_fname.entry.get_text());
  }
private:
  Gtk::Label l_fname;
  File_Entry e_fname;
};

PropBase* ImageMeta::getProp() {
  return new PropImage;
}
