///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <gtk--/main.h>

#include <util/warning.h>
#include <defines.h> // VERSION

#include "globals.h"
#include "window.h"
#include "processman.h"
#include "config.h"
#include "fileerrors.h"
#include "inspiration.h"

Config config;
Process_Manager process_manager("pptout");
std::string version=VERSION;
Inspiration *inspiration;
unsigned int border_width=5;

int main(int argc, char *argv[])
{
  int win_count=0;

  Gtk::Main kit(argc, argv);
  inspiration=manage(new Inspiration());

  for(int i=1; i<argc; i++)
    {
      std::string arg(argv[i]);
      if(arg=="-v") // print version number
	{
	  warning << "Passepartout " << version << std::endl;
	  return 0;
	}
      else if(arg=="-V") // be verbose
	{
	  verbose.active=true;
	}
      else if(arg=="-d") // be annoyingly verbose
	{
	  verbose.active=true;
	  debug.active=true;
	  // Why wait?
	  debug << "Debug mode active" << std::endl;
	}
      else if(arg=="-h" 
	      || arg=="--help") // display command line help
	{
	  warning << "Usage: pptout [options] [files...]" << std::endl;
	  warning << "\t-d\tShow debugging messages." << std::endl;
	  warning << "\t-h, --help\tShow this help message." << std::endl;
	  warning << "\t-V\tBe verbose." << std::endl;
	  warning << "\t-v\tShow version number." << std::endl;
	  return 0;
	}
      else 
	{
	  try
	    {
	      manage(new Frame_Window(arg, 0));
	      win_count++;
	    }
	  catch(const std::exception& err)
	    {
	      warning << "Error opening " << arg
		      << ": " << err.what() << std::endl;
	    }
	}
    }

  if(!win_count)
    {
      manage(new Frame_Window());
      win_count++;
    }

  // if no windows were opened, don't run the kit 
  if(win_count) {
    gdk_rgb_init();		// Needed before rendering pixbuf to screen.
    kit.run();
  }
  return 0;
}





