///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef METAFRAME_H		// -*- c++ -*-
#define METAFRAME_H
// An interface to get information about frame kinds.  To invent a new kind of
// frame, simply implement this interface and the objects it returns.
#include "group.h"
#include "propbase.h"

class MetaBase {
public:
  // May NOT return 0, but can throw an exception on any error.
  virtual Pagent* load(const XMLNode& node, Group* parent) = 0;

  virtual PropBase* getProp() = 0;
};

#endif
