///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef PAGE_H
#define PAGE_H

#include <list> 
#include "group.h"
#include <xml++.h>

class Document;

class Page: public Group {
public:
  Page(Document&);
  Page(const XMLNode& node, Document&);
  ~Page();
  
  XMLNode *save();
  void print(std::ostream &out);
  std::string get_name(); // return page number if no name
  FLength get_width() const;
  FLength get_height() const;
  FLength get_xpos() const;
  FLength get_ypos() const;

  bool draw_content(View& view);
  void act_on_zoom_factor_change();

  int get_page_num() const; // ask document what the page number is
  
  void addObject(Pagent* obj);
  
  const Document& get_document() const {return document;}
  Document& get_document() {return document;}
  
  void child_ready_to_draw(Pagent *pagent);
  static SigC::Signal1<void, Pagent*> ready_to_draw_page_signal;
protected:
  Document &document;

  Page &get_page() {return *this;}
  const Page &get_page() const {return *this;}
  
private:
  // Undefined ctors, avoid defaults
  Page(const Page&);
  Page();
  void operator = (const Page&);
};

// Check which page a particular pagent is on.  Declared here rather than in
// pagent since a pagent shouln't know anything about pages.
const Page& getPage(const Pagent& obj);

#endif
