///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "pagesel.h"
#include "safeslot.h"
#include "globals.h"
#include "fileerrors.h"
#include "page.h"
#include "document.h"
#include <util/stringutil.h>
#include <util/warning.h>
#include <gtk--/scrolledwindow.h>

void Pagesel::page_selected_action()
{
  if(Gtk::Label *num = dynamic_cast<Gtk::Label*> (pages.get_child()))
    document_view.set_current_page_num(to<int>(num->get_text()));
  else
    warning << "Arrggghhh! Not a Gtk::Label!" 
	    << " Please report this error." << std::endl;
  //run around in circles and scream!
}

void Pagesel::next()
{
  document_view.set_current_page_num(document_view.get_current_page_num()+1);
}

void Pagesel::prev()
{
  document_view.set_current_page_num(document_view.get_current_page_num()-1);
}

void Pagesel::update()
{
  int i;
  using namespace Gtk;
  using namespace Menu_Helpers;
  Gtk::Menu dummy;       // we have to change the menu and change it back
  pages.set_menu(dummy); // or else the OptionMenu widget won't notice that 
                         // the real menu has changed

  Document *document=document_view.get_document();
  MenuList& menu_list=menu.items();
  menu_list.clear();

  set_sensitive(document && document->get_num_of_pages());
  if(!document)
      return;

  i=document->get_first_page_num();
  while(i<(document->get_first_page_num()
	   +((int) document->get_num_of_pages())))
    {
      string tmp;

      // The doublesided feature is useless until we can display 
      // two pages at once, so it is disabled
      if(false // document->is_doublesided() 
	 && i==document->get_first_page_num() 
	 && i%2!=0)
	tmp="-";
      else
	{
	  if(document->get_page(i))
	    tmp=document->get_page(i)->get_name();
	  i++;
	}
      if(false) // document->is_doublesided())
	if(i<(document->get_first_page_num()
	      +((int) document->get_num_of_pages())))
	  {
	    if(document->get_page(i))
	      tmp+=", "+document->get_page(i)->get_name();
	    i++;
	  }
	else
	  tmp+=", -";
      menu_list.push_back(MenuElem(tmp));
    }
  int index=document_view.get_current_page_num()
    -document->get_first_page_num();
  menu.set_active(index);
  left.set_sensitive(index);
  right.set_sensitive(index<(((int) menu.items().size())-1));
  pages.set_menu(menu);
}

Pagesel::Pagesel(Document_View &docview)
  :document_view(docview)
{
  document_view.current_page_num_changed_signal.connect
    (safeslot(this, &Pagesel::update));
  document_view.document_changed_signal.connect
    (safeslot(this, &Pagesel::update));

  left.add(*manage(new Gtk::Arrow(GTK_ARROW_LEFT, GTK_SHADOW_NONE)));
  right.add(*manage(new Gtk::Arrow(GTK_ARROW_RIGHT, GTK_SHADOW_NONE)));
  //  left.set_relief(GTK_RELIEF_NONE);
  //  right.set_relief(GTK_RELIEF_NONE);

  pages.set_relief(GTK_RELIEF_NONE);
  
  update();
  pages.set_menu(menu);

  pack_start(left);
  pack_start(pages);
  pack_start(right);

  using namespace Gtk;

  left.clicked.connect(safeslot(this, &Pagesel::prev));
  right.clicked.connect(safeslot(this, &Pagesel::next));
  pages.get_menu()->selection_done.connect
    (safeslot(this, &Pagesel::page_selected_action));

  show_all();
}

Template_Page_Dialog::Template_Page_Dialog(Gtk::Window &parent, 
					   Document_View &document_view_):
  Gtk::Dialog(), 
  document_view(document_view_),
  ok_button(" OK "), cancel_button(" Cancel "),
  page_list(1), no_template_string("blank page")
{
  set_transient_for(parent);
  set_border_width(border_width);
  set_modal(true);
  set_policy(false, false, true);
  set_default_size(200, 200);
  //  page_list.set_column_width (0, 180);
  page_list.column(0).set_auto_resize(true);

  get_action_area()->pack_start(ok_button, true, false, 0);
  ok_button.set_flags(GTK_CAN_DEFAULT);
  get_action_area()->pack_start(cancel_button, true, false, 0);
  cancel_button.set_flags(GTK_CAN_DEFAULT);

  Gtk::ScrolledWindow *scroller=manage(new Gtk::ScrolledWindow);
  scroller->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  scroller->add(page_list);

  Gtk::Label *template_label=manage(new Gtk::Label("Select template page:"));
  template_label->set_alignment(0, template_label->get_yalign());
  get_vbox()->pack_start(*template_label);
  get_vbox()->pack_start(*scroller);
  get_vbox()->show_all();
  get_action_area()->show_all();
  ok_button.clicked.connect(safeslot(this, &Template_Page_Dialog::ok));
  cancel_button.clicked.connect(safeslot(this, 
					 &Template_Page_Dialog::cancel));
}

void Template_Page_Dialog::show_it(bool new_page_, int page_num_)
{
  if(new_page_)
    {
      set_title("New Page");
    }
  else
    {
      set_title("Template Page");
    }
  page_list.clear();
  new_page=new_page_; page_num=page_num_;
  Document *document=document_view.get_document();
  if(document)
    { 
      typedef std::list<std::string> Strings;
      Strings tmp=document->get_template_pages();
      if(tmp.begin()==tmp.end())
	{
	  // if we don't have any template pages then there's no point in 
	  // showing the dialog - we just create a blank page
	  ok();
	  return;
	}
      for(Strings::iterator i=tmp.begin();
	  i!=tmp.end();
	  i++)
	{
	  std::vector<Gtk::string> row;
	  row.push_back(*i);
	  page_list.rows().push_back(row);
	}
      std::vector<Gtk::string> row;
      row.push_back(no_template_string);
      page_list.rows().push_back(row);
      Gdk_Color color;
      color.set("red");
      page_list.rows().back().set_foreground(color);
      page_list.rows().front().select();
    }
  show();
}

void Template_Page_Dialog::ok()
{
  Document *document=document_view.get_document();
  if(new_page && document)
    {
      std::string page_name="";
      const Gtk::CList_Helpers::SelectionList &selection=page_list.selection();
      if(selection.begin()!=selection.end() && 
	 selection.begin()->begin()!=selection.begin()->end())
	page_name=selection.begin()->begin()->get_text();
      try
	{
	  if(page_name!="" && page_name!=no_template_string
	     && document->get_template())
	    {
	      Page *t_page=document->get_template()->get_page(page_name);
	      if(!t_page)
		{
		  Error_Dialog::view("Template page \""
				     +page_name
				     +"\" not found");
		  return;
		}
	      document->new_page(page_num, t_page); //problem here
	    }
	  else
	    document->new_page(page_num);
	}
      catch(const Error::Read &e)
	{
	  Error_Dialog::view(e.message);
	  return;
	}
    }
  hide();
}

void Template_Page_Dialog::cancel()
{
  hide();
}
