///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef PAGESEL_H
#define PAGESEL_H

#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/arrow.h>
#include <gtk--/optionmenu.h>
#include <gtk--/menu.h>
#include <gtk--/label.h>
#include <gtk--/clist.h>
#include "docview.h"
#include <gtk--/dialog.h>

class Pagesel: public Gtk::HBox
{
public:
  Pagesel(Document_View &docview);
private:
  Document_View &document_view;
  Gtk::Menu menu;
  Gtk::OptionMenu pages;
  Gtk::Button left, right;
  void next();
  void prev();
  void page_selected_action();
  void update();
};

class Template_Page_Dialog: public Gtk::Dialog
{
  Document_View &document_view;
  Gtk::Button ok_button, cancel_button;
  Gtk::CList page_list;
  bool new_page;
  int page_num;
  std::string no_template_string;
  void cancel();
  void ok();
public:
  Template_Page_Dialog(Gtk::Window &parent, Document_View &document_view_);
  void show_it(bool new_page_=false, int page_num_=0);
  int delete_event_impl(GdkEventAny*)
  {hide(); return true;}
};

#endif









