///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "paper_sizes.h"

Papers papers;

Papers::Papers()
{
  using namespace Units;

  // ISO golden section paper sizes 
  // - used in almost the entire civilised world
  sizes["A0"]=Size(to_pt(841, MM), to_pt(1189, MM));
  sizes["A1"]=Size(to_pt(594, MM), to_pt(841, MM));
  sizes["A2"]=Size(to_pt(420, MM), to_pt(594, MM));
  sizes["A3"]=Size(to_pt(297, MM), to_pt(420, MM));
  sizes["A4"]=Size(to_pt(210, MM), to_pt(297, MM));
  sizes["A5"]=Size(to_pt(148, MM), to_pt(210, MM));
  sizes["A6"]=Size(to_pt(105, MM), to_pt(148, MM));

  // paper sizes used in the U.S. and Canada
  // "Tabloid" and "Ledger" are two names for the same paper
  sizes["Letter"]=Size(to_pt(216, MM), to_pt(279, MM));
  sizes["Legal"]=Size(to_pt(216, MM), to_pt(356, MM));
  sizes["Executive"]=Size(to_pt(190, MM), to_pt(254, MM));
  sizes["Tabloid/Ledger"]=Size(to_pt(279, MM), to_pt(432, MM));
}
