///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef PAPER_SIZES_H
#define PAPER_SIZES_H

#include <string>
#include <map>
#include <stdexcept>
#include "units.h"

namespace Error
{
  struct Paper_Name : public std::invalid_argument {
    std::string name;
    Paper_Name(const std::string& _name) 
      :invalid_argument("No paper format named \"" + _name + "\""),
       name(_name) {}
    ~Paper_Name() throw() {}
  };
}

class Papers
{
public:
  enum Orientation {PORTRAIT, LANDSCAPE};

  class Size
  {
    FLength width, height;
  public:
    Size(FLength w, FLength h)
    {width=w; height=h;}
    Size()
    {width=-1; height=-1;}
    FLength get_width(Orientation o) const {return o==PORTRAIT?width:height;}
    FLength get_height(Orientation o) const {return o==PORTRAIT?height:width;}
  };

  std::map<std::string, Size> sizes;

  Papers();
};

extern Papers papers;

#endif
