///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef PIXBUFTRANSFORMATOR_H	// -*- c++ -*-
#define PIXBUFTRANSFORMATOR_H
#include "widget/pixbufwrap.h"
#include "view.h"

class PixbufTransformator : public SigC::Object {
public:
  PixbufTransformator(const Pixbuf& src, const View& v,  const Matrix& m);
  ~PixbufTransformator();
  
  const Pixbuf& getPixbuf() const { return buf; }
  bool isDone() const { return is_done; }
  gint workLine();

private:
  Pixbuf buf, srcpix;
  gint max_x, min_x, max_y, min_y;
  gint cur_y;
  bool is_done;
  Vector lstart, d_pix, d_line;
  
  // Undefined
  PixbufTransformator();
  PixbufTransformator(const PixbufTransformator&);
  void operator=(const PixbufTransformator&);
};

#endif
