///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef PRINTDIALOG_H
#define PRINTDIALOG_H

#include <gtk--/dialog.h>
#include <gtk--/button.h>
#include <gtk--/radiobutton.h>
#include <gtk--/checkbutton.h>
#include <gtk--/entry.h>
#include <gtk--/box.h>
#include "widget/spinner.h"
#include "widget/filesel.h"

class Document_View;

class Print_Dialog : public Gtk::Dialog
{
public:
  Print_Dialog(Gtk::Window &parent, Document_View &_document_view);
  void show_it();
  int delete_event_impl(GdkEventAny*)
  {hide(); return true;}

private:
  Gtk::Button ok_button, cancel_button;
  Gtk::RadioButton using_button, file_button, 
    all_button, current_button, from_button;
  Gtk::CheckButton eps_button, fonts_button;
  Gtk::Entry using_entry;
  Spinner from_spinner, to_spinner;
  Gtk::HBox using_box, file_box, from_to_box;
  Document_View &document_view; // document_view keeps record of the document
  File_Entry file_entry;
  Filesel *filesel;

  std::string saved_file_text, saved_using_text;
  bool saved_file_not_using, saved_eps;

  void cancel();
  void ok();
  void save_state(); // in case cancel is pressed we will restore inital state
  void restore_state();
  void update(); // make sure everything that should be grayed out is
};

#endif




