///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef PROCESSMAN_H
#define PROCESSMAN_H

#include <map>
#include <string>
#include <sigc++/basic_signal.h>
#include <sys/types.h>
#include <gtk--/main.h>

struct Process
{
  std::string command_line;
  Process(std::string line) :command_line(line)
  {}
  Process() :command_line("")
  {}
};

class Process_Manager: public SigC::Object
{
public:
  // Signal that a process has stopped,
  // attach process id, a bool to signify normal termination
  // and an exit code that is only meaningful if the bool is true:
  SigC::Signal3<void, pid_t, bool, int> process_stopped;

  Process_Manager(const std::string& filename_base);
  ~Process_Manager();
  pid_t start(std::string command);
  bool stop(pid_t pid);
  std::string find_new_name();
  bool delete_file(std::string);
  Process *get_process(pid_t pid);
  bool stop_all();
  gint run_check();
  int system(std::string);
private:
  typedef std::map<pid_t, Process> Processes;
  Processes processes;
  const std::string filename_template;
};

#endif
