///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef PROPBASE_H		// -*- c++ -*-
#define PROPBASE_H
#include <gtk--/table.h>
#include <gtk--/label.h>
#include "pagent.h"

// Base class for the different property sets.
// PropertiesDialog displays one PropBase at a time, through a Gtk Notebook.
class PropBase : public Gtk::Table {
public:
  typedef std::string string;
  
  PropBase(const string& name, int rows, int cols);
  Widget& getLabel() { return label; }
  
  virtual void update() = 0;	// Changes from object to dialog
  virtual void apply() = 0;	// Changes from dialog to object
  
  virtual void setObject(Pagent* pagent) = 0;

  void set_sensitive(bool sensitive);
  void right_justify(Gtk::Label &label);
private:
  Gtk::Label label;
};

template <class FrameC>
class GenericProp : public PropBase {
public:
  GenericProp(const string& label, int rows, int cols)
    :PropBase(label, rows, cols), object(0)
  {}
  void setObject(Pagent* pagent) {
    object = dynamic_cast<FrameC*>(pagent);
    set_sensitive(object);
    if(is_visible()) update();
  }
protected:
  FrameC* object;
};

#endif
