///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef PROPERTIESDIALOG_H	// -*- c++ -*-
#define PROPERTIESDIALOG_H
// A dialog displaying properties of the selected objeckt.  It will listen for
// selection events, so when the user selects a new object, the existing
// dialog will show properties for that object.
#include "document.h"
#include <gtk--/dialog.h>
#include <gtk--/notebook.h>
#include <gtk--/button.h>
#include <vector>

class PropBase;

class PropertiesDialog : public Gtk::Dialog {
public:
  PropertiesDialog();
  
  void showRaise();		// Make sure this dialog is visible
  void close();			// Put away this dialog
  void apply();			// Apply changes done in this dialog
  
  int delete_event_impl(GdkEventAny*) { close(); return true; }
  void *get_document() const
  {return document;}
  void set_document(Document *document_);
  
private:
  void select_change(Document* doc);		// signal listener
  void update();
  Document *document;

  Gtk::Notebook book;
  std::vector<PropBase*> pages;
  Gtk::Button apply_button, close_button;
};

#endif
