///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef RASTERFRAME_H		// -*- c++ -*-
#define RASTERFRAME_H
#include "filewatcher.h"
#include "basicframe.h"
#include "widget/pixbufwrap.h"
#include "pixbuftransformator.h"

class Raster_Frame: public Basic_Frame, public File_Watcher {
public:
  Raster_Frame(Group *parent, const XMLNode& node);
  Raster_Frame(Group *parent, const std::string& filename);
  virtual ~Raster_Frame();

  virtual XMLNode *save();
  virtual void print(std::ostream &out);

  bool draw_content(View& view);
  // Todo: implement clear_cache()

  void act_on_zoom_factor_change();

  void set_association(const std::string& s);
  std::string get_association() const {return association;}

  // Manage the ppi on paper (not the screen resolution).
  // dpi is printer resolution - ppi is image resolution
  Vector get_ppi();
  void set_ppi(const Vector& ppi); // scales the image
  
private:
  std::string association;
  
  Gdk_Point unit_size;		// Number of pixels in image
  Pixbuf filepixbuf, screenpixbuf;
  PixbufTransformator* worker;
  
  void loadUnitSize();
  std::string file_to_watch() const {return association;}
  void file_modified();
};

#endif



