///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "rastermeta.h"
#include "rasterframe.h"
#include "streamdialog.h"
#include "widget/spinner.h"
#include <gtk--/togglebutton.h>
#include <gtk--/separator.h>
#include "safeslot.h"
#include <util/warning.h>

Pagent* RasterMeta::load(const XMLNode& node, Group* parent){
  return new Raster_Frame(parent, node);
}

namespace {
  class PropRaster : public GenericProp<Raster_Frame> {
  public:
    PropRaster();
    
    void update();
    void apply();
  
    void toggleAspect();
    void change_val(bool x_active);
    
  private:
    float last_x, last_y;
    bool use_aspect;
    
    Gtk::Label l_fname, l_ppix, l_ppiy;
    File_Entry e_fname;
    Spinner e_ppix, e_ppiy;
    Gtk::ToggleButton b_ppic;
    Gtk::HSeparator hsep;
  };
};

PropBase* RasterMeta::getProp() {
  return new PropRaster;
}

PropRaster::PropRaster()
  :GenericProp<Raster_Frame>("Raster", 3, 4), use_aspect(false),
   l_fname("Filename:"), 
   l_ppix("PPI (x):"), l_ppiy("PPI (y):"),
   e_fname("Associated File"),  b_ppic("}")
{
  attach(l_fname, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND, 0);
  right_justify(l_fname);
  attach(e_fname, 1, 3, 0, 1, GTK_FILL | GTK_EXPAND, 0);
  attach(hsep,    0, 4, 1, 2);
  
  attach(l_ppix,  0, 1, 2, 3);
  right_justify(l_ppix);
  attach(e_ppix,  1, 2, 2, 3);
  attach(l_ppiy,  0, 1, 3, 4);
  right_justify(l_ppiy);
  attach(e_ppiy,  1, 2, 3, 4);
  attach(b_ppic,  2, 3, 2, 4, 0);
  e_ppix.changed.connect(safeslot(bind(slot(this, &PropRaster::change_val),
				       true)));
  e_ppiy.changed.connect(safeslot(bind(slot(this, &PropRaster::change_val),
				       false)));
  b_ppic.toggled.connect(safeslot(this, &PropRaster::toggleAspect));
  b_ppic.set_active(true);
  set_sensitive(false);
  update();
}

void PropRaster::update() {
  if(object) {
    e_fname.entry.set_text(object->get_association());
    
    const Vector ppi = object->get_ppi();
    e_ppix.set(ppi.x);
    e_ppiy.set(ppi.y);
    
  } else {
    e_fname.entry.set_text("");
  }
}
void PropRaster::apply() {
  if(!object) return;
  object->set_ppi(Vector(e_ppix.get(), e_ppiy.get()));
  object->set_association(e_fname.entry.get_text());
}

void PropRaster::toggleAspect() {
  use_aspect = b_ppic.get_active();
  if(object && use_aspect) {
    e_ppiy.set(e_ppix.get());	// Todo: * object->getAspectRatio()
  }
}

void PropRaster::change_val(bool x_active) {
  // The reason for all these temporary (and instance) x/y variables is that
  // i get "changed signals" (calls here) even when the change comes from
  // here, so I have to make sure I don't change anything the second time
  // around ...
  try {
    if(use_aspect) {
      const float x(e_ppix.get()), y(e_ppiy.get());
      if(x_active) {
	if(x != last_x) {
	  last_x = x; last_y = x; // Todo: * object->getAspectRatio()
	  e_ppiy.set(last_y);
	}
      } else {
	if(y != last_y) {
	  last_y = y; last_x = y; // Todo: / object->getAspectRatio()
	  e_ppix.set(last_x);
	}
      }
    }
  } catch(const std::exception& err) {
    warning << "Oups: " << err.what() << " (in change_val)" << std::endl;
  }
}
