///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef STREAMDIALOG_H
#define STREAMDIALOG_H

#include <gtk--/dialog.h>
#include <gtk--/button.h>
#include <gtk--/entry.h>
#include <gtk--/optionmenu.h>
#include <gtk--/menu.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/clist.h>
#include <gtk--/box.h>

#include "widget/filesel.h"

class Text_Stream;
class Document;

/*
 * Detailed properties for a single stream.
 * This dialog lets the user select what data file and which transform to
 * apply for a specific stream.
 */
class Stream_Properties_Dialog : public Gtk::Dialog
{
public:
  Stream_Properties_Dialog(Gtk::Window &parent);
  void show_it(Document *document_, std::string name=""); 
  // if name is empty - add stream

  int delete_event_impl(GdkEventAny*)
  {hide(); return true;}

private:
  Gtk::Button ok_button, cancel_button;
  Gtk::Entry name_entry;
  File_Entry file_entry;
  File_Entry xfrm_entry;
  Text_Stream *stream;
  Document *document;

  void cancel();
  void ok();
};

class Stream_Dialog: public Gtk::Dialog
{
public:
  Stream_Dialog();
  int delete_event_impl(GdkEventAny*)
  {hide_action(); return true;}
  void showRaise(); // Make sure this dialog is visible
  void set_document(Document *document_);
  
private:
  Gtk::CList stream_list;
  Gtk::HBox *button_box;
  Gtk::Button add_button, edit_button, delete_button, hide_button;
  Gtk::ScrolledWindow scroller;
  Document *document;
  Stream_Properties_Dialog *prop_dialog;

  void update(Document *document_); // called when the document streams 
                                    // have changed in any way
  void hide_action(); //hide dialog
  void add_action(); //add stream
  void edit_action(); //edit stream properties
  void delete_action(); //delete stream
};


class Stream_Menu: public Gtk::OptionMenu {
public:
  Stream_Menu();
  
  void set_document(Document *document_);

  // select_name must be an existing name in the document or an empty
  // string, which means no stream
  void update(std::string select_name="");

  std::string get_stream() const;

private:
  Document *document;
  Gtk::Menu menu;
};

#endif
