///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef TEXTFRAME_H
#define TEXTFRAME_H

#include "cachedframe.h"
#include "textstream.h"

class Text_Frame : public Cached_Frame {
public:

  Text_Frame(Group *parent, Text_Stream *stream,
	     FLength w, FLength h);
  Text_Frame(Group *parent, const XMLNode& node);
  virtual ~Text_Frame();

  virtual XMLNode *save();
  virtual void print(std::ostream &out);

  void set_text_stream(Text_Stream *text_stream, bool remove_from_old=true);
  // the destructor of Text_Stream sets remove_from_old=false
  // in order not to get a segmentation violation
  Text_Stream * get_text_stream() const {return text_stream;}
  //may return null

  std::string get_parsed_file() const {return parsed_file;}

  virtual void move_reshape_box(int box, Vector v);

  virtual void set_size(FLength w, FLength h);
  virtual void end_reshape(bool revert);

  int get_num_columns() const { return num_columns; }
  void set_num_columns(int columns);
  float get_gutter() const { return gutter_width; }
  void set_gutter(const float& gutter);

  bool ps_exists; // Todo: public member == bad
private:

  void generate_picture(View& view);

  std::string parsed_file;
  Text_Stream *text_stream;
  int num_columns;
  float gutter_width;

  // Todo: get rid of these:
  Gdk_Point pv;
  gdouble scrres;
};

#endif
