///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "textmeta.h"
#include "textframe.h"
#include "streamdialog.h"
#include <gtk--/separator.h>
#include "widget/spinner.h"
#include "document.h"

Pagent* TextMeta::load(const XMLNode& node, Group* parent) {
  return new Text_Frame(parent, node);
}

class PropText : public GenericProp<Text_Frame> {
public:
  PropText()
    :GenericProp<Text_Frame>("Text", 3, 4),
    l_flow("Text stream:"), l_columns("Num of Columns:"), 
    l_gutter("Gutter width:"),
    e_columns(1, false)
  {
      e_columns.limits(1, 64);	// Note: The upper limit is rather arbitrary.
      attach(l_flow,    0, 1, 0, 1);
      right_justify(l_flow);      
      attach(e_flow,    1, 3, 0, 1, GTK_FILL | GTK_EXPAND, 0);
      attach(hsep,      0, 4, 1, 2);
      
      attach(l_columns, 0, 2, 2, 3);
      right_justify(l_columns);      
      attach(e_columns, 2, 3, 2, 3);
      attach(l_gutter,  0, 2, 3, 4);
      right_justify(l_gutter);      
      attach(e_gutter,  2, 3, 3, 4);
      set_sensitive(false);
      update();
    }
  
  void update() {
    if(object) {
      //The text stream of a text frame may be null.
      //This will happen, for instance, when the stream 
      //associated with the frame is deleted.
      e_flow.set_document(&object->get_document());
      if(object->get_text_stream()) 
	e_flow.update(object->get_text_stream()->get_name());
      else
	e_flow.update();
      e_columns.set(object->get_num_columns());
      e_gutter.set(object->get_gutter());
    } else {
      e_flow.set_document(0);
      e_flow.update();
    }
  }
  void apply() {
    if(!object) return;
    object->set_num_columns(e_columns.get());
    object->set_gutter(e_gutter.get());
    Text_Stream *stream=object->get_document().get_text_stream(e_flow.get_stream());
    object->set_text_stream(stream);
  }
  
private:
  Gtk::HSeparator hsep;
  Gtk::Label l_flow, l_columns, l_gutter;
  Stream_Menu e_flow;
  Spinner e_columns, e_gutter;
};

PropBase* TextMeta::getProp() {
  return new PropText;
}

