///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef UNITS_H
#define UNITS_H

typedef float FLength; //Adobe points (1/72 in) by default

namespace Units
{
  enum Unit {MM, IN, PT};
  extern float conversion_factors[];//={72/25.4, 72, 1};

  FLength to_pt(FLength value, Unit unit);
    //  {return value*conversion_factors[unit];}
  FLength from_pt(FLength value, Unit unit);
    //  {return value/conversion_factors[unit];}
};

#endif
