///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef VIEW_H			// -*- c++ -*-
#define VIEW_H
#include "matrix.h"		// Just to get Vector.  Put in own file?
#include "units.h"		// FLength.  Put with Vector?
#include <gtk--/widget.h>

namespace Color {
  typedef enum Id { bg, frame, locked, empty };
}

class View {
public:
  virtual Gdk_Window& get_win() = 0;
  virtual Gdk_GC& get_gc() = 0;
  
  virtual gdouble get_scrres() const = 0;
  virtual FLength pt2scr(FLength pt) const = 0;
  virtual Gdk_Point pt2scr(const Vector& pt) const = 0;
  virtual Vector scr2pt(const Gdk_Point& scr) const = 0;

  virtual const Gdk_Pixmap &get_wait_pixmap() const = 0;
  virtual const Gdk_Pixmap &get_missing_pixmap() const = 0;
  virtual const Gdk_Pixmap &get_broken_pixmap() const = 0;
  
  virtual const Gdk_Color& get_color(Color::Id color) const = 0;
};

#endif
