///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "filesel.h"
//#include "safeslot.h"
#include <iostream>

// *** File_Entry methods ***

File_Entry::File_Entry(const std::string& window_title_, 
		       const std::string& default_path_):
  window_title(window_title_), default_path(default_path_),
  button(" Browse ... "), filesel(NULL)
{
  pack_start(entry, true, true, 0);
  pack_start(button, false, false, 0);
  button.show();
  entry.show();
  button.clicked.connect(slot(this, &File_Entry::show_filesel));
}

File_Entry::~File_Entry()
{
  delete filesel;
}

void File_Entry::filesel_done()
{
  if(!filesel->was_cancelled())
    entry.set_text(filesel->get_filename());
  delete filesel;
  filesel=NULL;
}

void File_Entry::show_filesel()
{
  filesel=new Filesel(*(this->get_toplevel()), window_title);
  filesel->hide.connect(slot(this, &File_Entry::filesel_done));
  filesel->set_filename(entry.get_text().empty() ? 
			default_path 
			: entry.get_text());
  filesel->show();
}

// *** Filesel methods ***

Filesel::Filesel(Gtk::Window &parent, const std::string& title)
  :cancelled(false)
{
  set_title(title);
  set_modal(true);
  get_ok_button()->clicked.connect(slot(this, &Filesel::ok));
  get_cancel_button()->clicked.connect(slot(this, &Filesel::cancel));

  set_transient_for(parent);
}

void Filesel::cancel()
{
  set_filename("");
  cancelled=true;
  hide();
}

void Filesel::ok()
{
  std::string filename=get_filename();

  //  cerr<<filename.at(filename.length()-1)<<endl;
  if(filename.at(filename.length()-1)!='/')
    {
      cancelled=false;
      hide();
    }
}
