///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef FILESEL_H
#define FILESEL_H

#include <gtk--/fileselection.h>
#include <gtk--/box.h>
#include <string>

class Filesel;

class End_Entry: public Gtk::Entry
{
public:
  void set_text(const std::string &text)
  {Gtk::Entry::set_text(text); set_position(text.length());}
};

class File_Entry: public Gtk::HBox
{
public:
  End_Entry entry;
  File_Entry(const std::string& window_title_, 
	     const std::string& default_path_="");
  ~File_Entry();

private:
  std::string window_title, default_path;
  Gtk::Button button;
  Filesel *filesel;
  void filesel_done();
  void show_filesel();
};

//file selection dialog
class Filesel: public Gtk::FileSelection
{
 public:
  Filesel(Gtk::Window &parent, const std::string& title);
  bool was_cancelled() const
  {return cancelled;}
  virtual int delete_event_impl(GdkEventAny*)
  {cancel(); return true;}

private:
  void cancel();
  void ok();
  bool cancelled;
};

#endif

