///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef PIXBUFWAP_H		// -*- c++ -*-
#define PIXBUFWAP_H
#include <gdk--/drawable.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <string>

// This is a simplistic c++ wrapper for GdkPixbuf.  There is such a wrapper in
// development versions of gtkmm, so when those reach stability this is
// suposed to be replaced by that.  So don't add any fancy features here, it
// is just a thin wrapper.

// A Pixbuf has "value" semantics, just like many other gdk wrappers.  That
// means that it is perfectly legal to use the assignment operator and copy
// constructor.  The actual object will not be copied, but it is reference
// counted, so it will be released when the last Pixbuf wrapping "it" is
// released (by destructor or unref).

class Pixbuf {
public:
  struct Statistics{
    bool grayscale;
    bool suggest_rle;
  };

  Pixbuf() : buf(0) {}
  explicit Pixbuf(const std::string imagefile);
  Pixbuf(int width, int height);
  Pixbuf(const Pixbuf& orig);
  ~Pixbuf();
  Pixbuf& operator = (const Pixbuf&);
  
  bool operator ! () const { return !buf; }
  operator bool () const { return buf; }
  void unref();
  
  int get_width() const;
  int get_height() const;
  GdkColorspace get_colorspace() const;
  
  void load_file(const std::string imagefile);

  Pixbuf scale(int width, int height);
  void render_to_drawable(Gdk_Drawable& drawable, GdkGC& gc,
			  int xsrc, int ysrc, int xdest, int ydest,
			  int width = -1, int height = -1);
  void render_to_drawable_alpha(Gdk_Drawable& drawable,
				int xsrc, int ysrc, int xdest, int ydest,
				int width = -1, int height = -1);
  
  // Access to the actual bits.  Use only if you know what youre doing
  guchar* get_pixels();
  int get_rowstride() const;
  int get_n_channels() const;
  
  // Try to guess stuff about the pixbuf that GdkPixbuf should have told us:
  Statistics calc_stats(int samples=100);

private:
  GdkPixbuf* buf;
};

#endif
