///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "spinner.h"

Spinner::Spinner(const float value, bool allow_float)
  : SpinButton(0, allow_float? 2: 0), value_(value, 0, 8000)
{
  set_adjustment(value_);
  set_numeric(false);
  if(!allow_float) set_snap_to_ticks(true);
}

void Spinner::limits(const float& low, const float& high) {
  value_.set_lower(low);
  value_.set_upper(high);
}
