///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef WINDOW_H
#define WINDOW_H

#include <list>
#include <iostream>

#include <gtk--/window.h>
#include <gtk--/main.h>
#include <gtk--/button.h>
#include <gtk--/box.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/statusbar.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/toolbar.h>
#include <gtk--/optionmenu.h>
#include <gtk--/table.h>
#include <gtk--/ruler.h>
#include <gtk--/pixmap.h>

#include "docview.h"
#include "icons/icons.h"

class Pagesel;
class Filesel;
class Print_Dialog;
class Stream_Dialog;
class PropertiesDialog;
class Doc_Props_Dialog;

class Frame_Window : public Gtk::Window 
{
public:
  Frame_Window(std::string filename = "", Doc_Props_Dialog *dp_dialog = 0);
  ~Frame_Window();

protected:
  int delete_event_impl(GdkEventAny*);
  int focus_in_event_impl(GdkEventFocus*);

private:
  static unsigned int count;
  static Frame_Window *active_window; // pointer to the currently active window
  static PropertiesDialog *properties_dialog;
  static Stream_Dialog *stream_dialog;
  Gtk::Toolbar toolbar;
  Gtk::HBox hbox, pagebar;
  Gtk::VBox main_container, vbox;
  Gtk::ScrolledWindow scroller;
  Gtk::Table table, document_table;
  Gtk::Statusbar cafe_opera;
  Gtk::MenuBar menubar;
  Gtk::OptionMenu zoom_factor;
  Filesel *open_dialog, *save_dialog, *import_dialog;
  Document_View document_view;
  Print_Dialog *print_dialog;
  Doc_Props_Dialog *doc_props_dialog;
  Gtk::HRuler hrule;
  Gtk::VRuler vrule;
  std::list<std::string> zoom_factors;
  Pagesel *pagesel;
  std::string preview_tmp_file; // temp file to write ps to when previewing

  // We need to create separate copies of the icons for each window since each
  // icon can only have one parent
  Icons icons; 

  void set_filename(std::string);
  void document_updated(Document *document_); // change IN document
  void document_changed(); // change OF document
  void document_filename_changed(Document *document_); 
  void new_document();
  void destroy_handler();
  void print_to_viewer();
  void quit();
  void zoom_change_action(float);
  void update_rulers();
  void zoom_factor_changed_action();
  Gtk::Menu* create_zoom_menu();
  void create_menus();
  bool locked;
  void toggle_rulers();
  void toggle_cafe_opera();
  void toggle_toolbar();
  void open_dialog_done();
  void save_dialog_done();
  void import_dialog_done();
  void save();
  void close();
  void do_nothing();
  void show_doc_props_dialog();
  void show_template_page_dialog();
};

#endif







