///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "stringutil.h"
#include <stdlib.h>
// #include <unistd.h>
#include <cctype>

bool whitespace(char c)
{
  return isspace(c);
}

std::string strip_whitespace(std::string s, bool front, bool back)
{
  int b=0;
  int l=s.length()-1;
  while(front && b<=l && whitespace(s[b]))
    b++;
  while(back && l>=0 && whitespace(s[l]))
    l--;
  return s.substr(b, l-b+1);
}

bool starts_with(const std::string& str, const std::string& start) {
  std::string::size_type len = start.length();
  return str.length() >= len && str.substr(0, len) == start;
}
