///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef STRINGUTIL_H		// -*- c++ -*-
#define STRINGUTIL_H
#include <string>
#ifdef USE_OLD_STRSTREAM
#  include <strstream>
#else
#  include <sstream>
#endif
#include <stdexcept>
// The to / from string converters here is declared inline, since that is a
// lot easier than actually makeing partial template compilation work as it
// should.

template <class C>
C to(const std::string &value) {
#ifdef USE_OLD_STRSTREAM
  std::istrstream s(value.c_str(), value.length());
#else
  std::istringstream s(value);
#endif
  C c;
  if(s >> c)			// Todo:  Also check there is no trailing junk!
    return c;
  throw std::runtime_error("Bad value: \"" + value + '"');
}

template <class C>
std::string tostr(C c) {
#ifdef USE_OLD_STRSTREAM
  std::ostrstream s;
#else
  std::ostringstream s;
#endif
  s << c << std::ends;
  return s.str();
}

bool whitespace(char c);

std::string strip_whitespace(std::string s, bool front=true, bool back=true);

bool starts_with(const std::string& str, const std::string& start);

inline bool starts_with(const std::string& str, char start) {
  return str.length() > 0 && str[0] == start;
}

#endif
