///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- c++ -*-
#ifndef STDERR_H 
#define STDERR_H
#include <iostream>

// Aliases for std::cerr that can be turned off.

struct cerr_Alias
{
  explicit cerr_Alias(bool a) : active(a) {}

  bool active;

  template<class A>
  std::ostream &operator<<(const A &a)
    {if(active) return std::cerr << a; else return null;}

private:
  static std::ostream null;
};

// serious stuff, should not be turned off
extern cerr_Alias warning;

// for people who want to know what happens behind the scenes
extern cerr_Alias verbose;

// debug stuff that means nothing to the user
extern cerr_Alias debug;

#endif
