///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "boundaries.hh"
#include <algorithm>		// swap
#include <stdexcept>
#ifdef USE_OLD_STRSTREAM
#  include <strstream>
#else
#  include <sstream>
#endif

xml2ps::PageSize::PageSize(const string& s)
  : gutter_(10), columns_(1) 
{
  using std::runtime_error;
#ifdef USE_OLD_STRSTREAM
  std::istrstream in(s.c_str(), s.length());
#else
  std::istringstream in(s);
#endif
  if(!(in >> width_)) throw runtime_error("Bad format: \"" + s + "\"");
  char c;
  if(!((in >> c) && (c == 'x')))
    throw runtime_error("Bad format: \"" + s + "\"");
  if(!(in >> height_)) throw runtime_error("Bad format: \"" + s + "\"");
  if(in >> c >> columns_ >> gutter_) {
    if(c != '/') throw runtime_error("Bad format: \"" + s + "\"");
  } else {
    if(!in.eof()) throw runtime_error("Bad format: \"" + s + "\"");
  }
}

xml2ps::Obstacle::~Obstacle() {}

xml2ps::SquareObstacle::SquareObstacle(float left_x, float bottom_y,
				       float right_x, float top_y)
  :x1(left_x), bottom_(bottom_y), x2(right_x), top_(top_y)
{
  if(bottom_ > top_) std::swap(bottom_, top_);
  if(x1 > x1) std::swap(x1, x2);
}

xml2ps::SquareObstacle::SquareObstacle(const string& init) {
#ifdef USE_OLD_STRSTREAM
  std::istrstream in(init.c_str(), init.length());
#else
  std::istringstream in(init);
#endif
  float w, h;
  char x;
  if(!(in >> w >> x >> h >> x1 >> bottom_) || (x != 'x'))
    throw std::runtime_error("Bad SquareObstacle init string: \"" + init + "\"");
  x2 = x1 + w;
  top_ = bottom_ + h;
}

xml2ps::HBox&
xml2ps::SquareObstacle::intersect(HBox& hbox) const {
  if(bottom_ < hbox.top() && top_ > hbox.bottom()) {
    // The hline is within the height of the obstacle
    const float leftside = this->x2 - hbox.left();
    const float rightside = hbox.right() - this->x1;
    
    if(leftside < 0 || rightside < 0)
      return hbox;

    if(leftside > rightside)
      hbox.inRight(rightside);
    else
      hbox.inLeft(leftside);
  }
  return hbox;
}


xml2ps::PageBoundary::~PageBoundary() {
  // Todo: Yes, I should delete the obstacles, but first I need to solve the
  // copy problem (referece counting?)
//   for(ObVec::iterator i = obstacles.begin(); i != obstacles.end(); ++i)
//     delete *i;
}

