///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef X2P_CANVAS
#define X2P_CANVAS
// An abstract class for a canvas.  For instantiation, there is a subclass
// PsCanvas that writes to a PsStream.  later on, there might be an XCanvas or
// something that draws on a window for fast interaction with pptout.

// The Canvas has knowledge about columns, and about the "current" column.
// When the current column is filled, the next is started.
#include <string>
#include <vector>
#include "boundaries.hh"
#include "fontinfo.hh"
#include <stdexcept>

namespace xml2ps {
  class out_of_pages : public std::overflow_error {
  public:
    out_of_pages() : overflow_error("Out of pages") {}
  };
  
class Canvas {
public:
  explicit Canvas(const std::vector<xml2ps::PageBoundary>& pages,
		  bool allow_extra_pages);
  virtual ~Canvas();

  // return the x coordinates of the current hbox.
  HBox hbox(bool span, float margin_left, float margin_right, 
	    float ascender, float descender);
  
  // Check where the current column starts.
  virtual void addMargin(const float& m);

  // Make sure there is hspace in current column, or move on to the next.
  virtual void reserveHeight(const float& hspace, bool span = false);
  // Move the cursor down in the current column.
  virtual const float& down(const float& step);

  virtual void newPage();
  
  virtual void setfont(const FontInfo& font) = 0;
  virtual void moveto(float hpos, float vpos) = 0;
  virtual void moverel(float dx, float dy) = 0;
  virtual void show(const string& text) = 0;
  virtual void whitespace(const float& space) = 0;
  virtual void underlineFrom(const float& below) = 0;
  virtual void underlineTo(const float& below, const float& thickness) = 0;

  virtual void line(float x1, float y1, float x2, float y2) = 0;

protected:
  typedef std::vector<xml2ps::PageBoundary> PageVec;
  const PageVec pages_;
  PageVec::const_iterator cur_page_;
private:
  bool allow_extra_pages_;
  float height_;		// height _below_ spanning stuff
  float vpos, margin;
  int cur_column;
};
};

#endif
