///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "fontinfo.hh"
#include "fontmanager.hh"

xml2ps::FontManager *xml2ps::FontInfo::fm = 0;

void
xml2ps::FontInfo::init(const FontPaths *fontPaths) {
  if(!fm)
    {
      fm = new FontManager();
      if(fontPaths && !fontPaths->empty())
	{
	  for(FontPaths::const_iterator i=fontPaths->begin();
	      i!=fontPaths->end();
	      i++)
	    fm->addFontPath(*i);
	}
      else // some guesses:
	{
	  fm->addFontPath("/usr/local/share/ghostscript/fonts");
	  fm->addFontPath("/usr/X11R6/lib/X11/fonts/freefont");
	  fm->addFontPath("/usr/share/fonts/type1/gsfonts");     // Debian
	  fm->addFontPath("/mpkg/ghostscript/7.02/fonts");       // Elektro
	  fm->addFontPath("/mpkg/ghostscript/7.04/fonts");       // Elektro
	  fm->addFontPath("/mpkg/ghostscript/6.50/fonts");       // Elektro
	}

      // Ghostscript replacements for Adobe fonts:
      fm->fontAlias("Bookman-Demi",               "URWBookmanL-DemiBold");
      fm->fontAlias("Bookman-DemiItalic",         "URWBookmanL-DemiBoldItal"); 
      fm->fontAlias("Bookman-Light",              "URWBookmanL-Ligh"); 
      fm->fontAlias("Bookman-LightItalic",        "URWBookmanL-LighItal");

      fm->fontAlias("Courier",                    "NimbusMonL-Regu");
      fm->fontAlias("Courier-Oblique",            "NimbusMonL-ReguObli");
      fm->fontAlias("Courier-Bold",               "NimbusMonL-Bold");
      fm->fontAlias("Courier-BoldOblique",        "NimbusMonL-BoldObli");

      fm->fontAlias("Times-Roman",                "NimbusRomNo9L-Regu");
      fm->fontAlias("Times-Italic",               "NimbusRomNo9L-ReguItal");
      fm->fontAlias("Times-Bold",                 "NimbusRomNo9L-Medi");
      fm->fontAlias("Times-BoldItalic",           "NimbusRomNo9L-MediItal");

      fm->fontAlias("Helvetica",                  "NimbusSanL-Regu");
      fm->fontAlias("Helvetica-Oblique",          "NimbusSanL-ReguItal");
      fm->fontAlias("Helvetica-Bold",             "NimbusSanL-Bold");
      fm->fontAlias("Helvetica-BoldOblique",      "NimbusSanL-Regu");

      fm->fontAlias("Helvetica-Narrow",                  "NimbusSanL-ReguCond");
      fm->fontAlias("Helvetica-Narrow-Oblique",          "NimbusSanL-ReguCondItal");
      fm->fontAlias("Helvetica-Narrow-Bold",             "NimbusSanL-BoldCond");
      fm->fontAlias("Helvetica-Narrow-BoldOblique",      "NimbusSanL-ReguCond");

      fm->fontAlias("Palatino-Roman",             "URWPalladioL-Roma");
      fm->fontAlias("Palatino-Italic",            "URWPalladioL-Ital");
      fm->fontAlias("Palatino-Bold",              "URWPalladioL-Bold");
      fm->fontAlias("Palatino-BoldItalic",        "URWPalladioL-BoldItal");

      fm->fontAlias("AvantGarde-Book",            "URWGothicL-Book");
      fm->fontAlias("AvantGarde-BookOblique",     "URWGothicL-BookObli");
      fm->fontAlias("AvantGarde-Demi",            "URWGothicL-Demi");
      fm->fontAlias("AvantGarde-DemiOblique",     "URWGothicL-DemiObli");

      fm->fontAlias("NewCenturySchlbk-Roman",     "CenturySchL-Roma"); 
      fm->fontAlias("NewCenturySchlbk-Italic",    "CenturySchL-Ital"); 
      fm->fontAlias("NewCenturySchlbk-Bold",      "CenturySchL-Bold"); 
      fm->fontAlias("NewCenturySchlbk-BoldItalic","CenturySchL-BoldItal"); 


      fm->fontAlias("Symbol",                     "StandardSymL");

      fm->fontAlias("ZapfChancery-MediumItalic",  "URWChanceryL-MediItal");

      fm->fontAlias("ZapfDingbats",               "Dingbats");

      //      fm->reportFonts(std::cerr);
    }
}

xml2ps::FontInfo::FontInfo(const std::string& n, float s, float spacing)
  : name(n), metrics(*fm->getFont(n)), size(s), letter_spacing(spacing)
  {}

xml2ps::FontInfo
xml2ps::FontInfo::WidenFont(const FontInfo& orig, const float& widen) {
  FontInfo result(orig);
  result.letter_spacing += widen;
  return result;
}

float
xml2ps::FontInfo::getWidth(const string& s) const {
  return metrics.getWidth(s)*size + letter_spacing*s.length(); 
}
