///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef X2P_FONTINFO
#define X2P_FONTINFO
#include <string>
#include <vector>

#include "fontmetrics.hh"

namespace xml2ps {
  
  class FontManager;

  struct FontInfo {
    typedef std::vector<std::string> FontPaths;
    typedef std::string string;
    FontInfo(const std::string& n, float s, float spacing = 0);
    FontInfo(const std::string& n, const font::Metrics& m, float s)
      : name(n), metrics(m), size(s) {}
    
    static FontInfo WidenFont(const FontInfo&orig, const float& widen);
    
    const std::string& getName() const { return name; }
    const float&  getSize() const { return size; }
    const float& getLetterSpacing() { return letter_spacing; }
    
    float getWidth(const string& s) const;
    float getAscender() const { return metrics.getAscender() * size; }
    float getDescender() const { return metrics.getDescender() * size; }
    float getUnderlinePos() const { return metrics.getUnderlinePos()* size; }
    float getUnderlineThickness() const
      { return metrics.getUnderlineThickness() * size; }
    
    // If fontPaths is NULL, a default list is used:
    static void init(const FontPaths *fontPaths=0);

  private:
    const std::string name;
    const font::Metrics &metrics;
    float size, letter_spacing;
    static FontManager* fm;
  };

  typedef std::vector<FontInfo*> Fonts;
  
};

#endif
