///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// -*- C++ -*-
#ifndef X2P_FONTMANAGER
#define X2P_FONTMANAGER
#include <string>
#include <map>
#include <stdexcept>
#include "fontmetrics.hh"

namespace xml2ps{

  struct FontError: public std::runtime_error {
    FontError(std::string what) : std::runtime_error(what) {}
  };

class FontManager {
  typedef std::string string;
  typedef std::map<string, font::Metrics*> MetricsMap;

public:
  enum generic_font { serif, sans_serif, cursive, fantasy, monospace };

  FontManager();

  // Paths are searched in the order thay are added:
  void addFontPath(std::string path);
  // A font can have more than one name:
  // Warning: no cyclic references, please!
  void fontAlias(std::string alias, std::string fontname);
  const font::Metrics* getFont(const string &name);
  void reportFonts(std::ostream &out);

protected:
  void loadFont(const string &fontname);
  void checkOutAFM(std::string filename);
  void checkOutType1(std::string filename); // does nothing
  std::pair<std::string, std::string> getFontFiles(const string &fontname);
private:
  FontManager(const FontManager &); // undefined
  FontManager& operator= (const FontManager &);	// undefined
  MetricsMap metrics_map;
  typedef std::multimap<std::string, std::string> FontAliases;
  FontAliases fontaliases;
  // <fontname, pair<metrics file, font file>>
  typedef std::map<std::string, std::pair<std::string, std::string> > FontFiles;
  FontFiles fontfiles;
};
}
#endif
