///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// class for reading Adobe Font Metrics.                            -*- C++ -*-
#ifndef SSC_FONTMETRICS_H
#define SSC_FONTMETRICS_H
#include <string>
#include <vector>
#include <map>

namespace font {
  class Metrics {
  public:
    Metrics(std::istream &source);
    
    float getWidth(const std::string &str) const;
    float getAscender()  const { return ascender; }
    float getDescender() const { return descender; }
    float getExHeight()  const { return x_height; }
    float getUnderlinePos() const { return underline_position; }
    float getUnderlineThickness() const { return underline_thickness; }
    
  private:
    float ascender, descender;
    float underline_position, underline_thickness;
    float cap_height, x_height;
    float width_x[256];
    
    class Encoding;
    static const Encoding* encoding;
    
    Metrics();
    Metrics(const Metrics&);
    void operator = (const Metrics&);
  };
}

#endif
