///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "pdfcanvas.hh"

xml2ps::PDFCanvas::PDFCanvas(std::streambuf *buf, 
			     const std::vector<xml2ps::PageBoundary>& pages,
			     bool allow_extra_pages)
  : Canvas(pages, allow_extra_pages), out(buf)
{
  newPage();
}

xml2ps::PDFCanvas::~PDFCanvas() {
  document.write(&out);
}

void xml2ps::PDFCanvas::newPage() {
  Canvas::newPage();
  document.add_page(cur_page_->width(), cur_page_->height());
}

void xml2ps::PDFCanvas::setfont(const FontInfo& font) {
  document.selectfont(font.getSize());
}

void xml2ps::PDFCanvas::moveto(float hpos, float vpos) {
  document.moveto(hpos, vpos);
}
void xml2ps::PDFCanvas::moverel(float dx, float dy) {
  document.rmoveto(dx, dy);
}

void xml2ps::PDFCanvas::show(const string& text) {
  //  const float ls = font_->getLetterSpacing();
  document.show(text);
}

void xml2ps::PDFCanvas::whitespace(const float& space) {
  document.whitespace(space);
}

void xml2ps::PDFCanvas::underlineFrom(const float& below) {
  // who needs it anyway?
}

void
xml2ps::PDFCanvas::underlineTo(const float& below, const float& thickness) {
  // who needs it anyway?
}

void
xml2ps::PDFCanvas::line(float x1, float y1, float x2, float y2) {
  // Todo: implement drawing a simple line.
}
