///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "pscanvas.hh"
#include <algorithm>                // max?
#include <iomanip>
#include <stdexcept>

xml2ps::PsCanvas::PsCanvas(std::streambuf *buf, 
			   const std::vector<xml2ps::PageBoundary>& pages,
			   bool allow_extra_pages)
  : Canvas(pages, allow_extra_pages)
{
  out.reset(new PsStream(buf));
  newPage();
}

xml2ps::PsCanvas::~PsCanvas() {}

void xml2ps::PsCanvas::newPage() {
  out->closePage();
  Canvas::newPage();
  out->newPage(cur_page_->width(), cur_page_->height());
}

void xml2ps::PsCanvas::setfont(const FontInfo& font) {
  font_.reset(new FontInfo(font));
  out->require_font(font_->getName());
  (*out) << font_->getSize() << " (" << font_->getName() << ") F" << std::endl;
}

void xml2ps::PsCanvas::moveto(float hpos, float vpos) {
  (*out) << hpos << ' ' << vpos << " M" << std::endl;
}
void xml2ps::PsCanvas::moverel(float dx, float dy) {
  (*out) << dx << ' ' << dy << " rmoveto" << std::endl;
}

void xml2ps::PsCanvas::show(const string& text) {
  (*out) << '(';
  for(string::const_iterator i = text.begin(); i != text.end(); ++i) {
    switch(*i & 0xFF) {
    case 160: case '(': case ')':
      (*out) << '\\' << std::oct << std::setw(3) << std::setfill('0')
	  << (*i & 0xFF);
      break;
//     case '(': (*out) << "\\("; break;
//     case ')': (*out) << "\\)"; break;
    default:  (*out) << *i; break;
    }
  }
  (*out) << ") ";
  const float ls = font_->getLetterSpacing();
  if(ls) (*out) << ls << " 0 3 -1 roll ashow" << std::endl;
  else   (*out) << 'S' << std::endl;
}
void xml2ps::PsCanvas::whitespace(const float& space) {
  (*out) << space << " WS ";
}

void xml2ps::PsCanvas::underlineFrom(const float& below) {
  (*out) << below << " UFROM ";
}
void
xml2ps::PsCanvas::underlineTo(const float& below, const float& thickness) {
  (*out) << thickness << ' ' << below << " UTO" << std::endl;
}

void
xml2ps::PsCanvas::line(float x1, float y1, float x2, float y2) {
  (*out) << "newpath " << x1 << ' ' << y1 << " moveto "
	 << x2 << ' ' << y2 << " lineto stroke" << std::endl;
}
