///
// Copyright (C) 2002, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef X2P_PSCANVAS
#define X2P_PSCANVAS
// See canvas.hh for discussion
#include "canvas.hh"
#include "psstream.hh"
#include <memory>

namespace xml2ps {
class PsCanvas : public Canvas {
public:
  PsCanvas(std::streambuf* buf, 
	   const std::vector<xml2ps::PageBoundary>& pages,
	   bool allow_extra_pages);
  virtual ~PsCanvas();
  
  virtual void newPage();
  
  void setfont(const FontInfo& font);
  void moveto(float hpos, float vpos);
  void moverel(float dx, float dy);
  
  void show(const string& text);
  void whitespace(const float& space);
  
  void underlineFrom(const float& below);
  void underlineTo(const float& below, const float& thickness);
  
  void line(float x1, float y1, float x2, float y2);
  
private:
  std::auto_ptr<PsStream> out;
  std::auto_ptr<FontInfo> font_;
};
};
#endif
